package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerSpecBuilder extends APIServerSpecFluentImpl<APIServerSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.APIServerSpec,APIServerSpecBuilder>{
  public APIServerSpecBuilder() {
    this(false);
  }
  public APIServerSpecBuilder(Boolean validationEnabled) {
    this(new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(APIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,io.fabric8.openshift.api.model.APIServerSpec instance) {
    this(fluent, instance, false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,io.fabric8.openshift.api.model.APIServerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
    fluent.withAudit(instance.getAudit()); 
    fluent.withClientCA(instance.getClientCA()); 
    fluent.withEncryption(instance.getEncryption()); 
    fluent.withServingCerts(instance.getServingCerts()); 
    fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpec instance) {
    this(instance,false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
    this.withAudit(instance.getAudit()); 
    this.withClientCA(instance.getClientCA()); 
    this.withEncryption(instance.getEncryption()); 
    this.withServingCerts(instance.getServingCerts()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServerSpec build() {
    APIServerSpec buildable = new APIServerSpec(fluent.getAdditionalCORSAllowedOrigins(),fluent.getAudit(),fluent.getClientCA(),fluent.getEncryption(),fluent.getServingCerts(),fluent.getTlsSecurityProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}