package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPlatformStatusBuilder extends AWSPlatformStatusFluentImpl<AWSPlatformStatusBuilder> implements VisitableBuilder<AWSPlatformStatus,io.fabric8.openshift.api.model.AWSPlatformStatusBuilder>{
  public AWSPlatformStatusBuilder() {
    this(false);
  }
  public AWSPlatformStatusBuilder(Boolean validationEnabled) {
    this(new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegion(instance.getRegion()); 
    fluent.withResourceTags(instance.getResourceTags()); 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatus instance) {
    this(instance,false);
  }
  public AWSPlatformStatusBuilder(io.fabric8.openshift.api.model.AWSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegion(instance.getRegion()); 
    this.withResourceTags(instance.getResourceTags()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AWSPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AWSPlatformStatus build() {
    AWSPlatformStatus buildable = new AWSPlatformStatus(fluent.getRegion(),fluent.getResourceTags(),fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}