package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationStatusBuilder extends AuthenticationStatusFluentImpl<AuthenticationStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.AuthenticationStatus,io.fabric8.openshift.api.model.AuthenticationStatusBuilder>{
  public AuthenticationStatusBuilder() {
    this(false);
  }
  public AuthenticationStatusBuilder(Boolean validationEnabled) {
    this(new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationStatusBuilder(io.fabric8.openshift.api.model.AuthenticationStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(io.fabric8.openshift.api.model.AuthenticationStatusFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationStatus instance) {
    this(fluent, instance, false);
  }
  public AuthenticationStatusBuilder(io.fabric8.openshift.api.model.AuthenticationStatusFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationStatusBuilder(io.fabric8.openshift.api.model.AuthenticationStatus instance) {
    this(instance,false);
  }
  public AuthenticationStatusBuilder(io.fabric8.openshift.api.model.AuthenticationStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AuthenticationStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AuthenticationStatus build() {
    AuthenticationStatus buildable = new AuthenticationStatus(fluent.getIntegratedOAuthMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}