package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalPlatformStatusBuilder extends BareMetalPlatformStatusFluentImpl<BareMetalPlatformStatusBuilder> implements VisitableBuilder<BareMetalPlatformStatus,io.fabric8.openshift.api.model.BareMetalPlatformStatusBuilder>{
  public BareMetalPlatformStatusBuilder() {
    this(false);
  }
  public BareMetalPlatformStatusBuilder(Boolean validationEnabled) {
    this(new BareMetalPlatformStatus(), validationEnabled);
  }
  public BareMetalPlatformStatusBuilder(BareMetalPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalPlatformStatusBuilder(io.fabric8.openshift.api.model.BareMetalPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BareMetalPlatformStatus(), validationEnabled);
  }
  public BareMetalPlatformStatusBuilder(io.fabric8.openshift.api.model.BareMetalPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.BareMetalPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public BareMetalPlatformStatusBuilder(io.fabric8.openshift.api.model.BareMetalPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.BareMetalPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BareMetalPlatformStatusBuilder(io.fabric8.openshift.api.model.BareMetalPlatformStatus instance) {
    this(instance,false);
  }
  public BareMetalPlatformStatusBuilder(io.fabric8.openshift.api.model.BareMetalPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BareMetalPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BareMetalPlatformStatus build() {
    BareMetalPlatformStatus buildable = new BareMetalPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}