package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BrokerTemplateInstanceSpecFluentImpl<A extends BrokerTemplateInstanceSpecFluent<A>> extends BaseFluent<A> implements BrokerTemplateInstanceSpecFluent<A>{
  public BrokerTemplateInstanceSpecFluentImpl() {
  }
  public BrokerTemplateInstanceSpecFluentImpl(io.fabric8.openshift.api.model.BrokerTemplateInstanceSpec instance) {
    this.withBindingIDs(instance.getBindingIDs()); 
    this.withSecret(instance.getSecret()); 
    this.withTemplateInstance(instance.getTemplateInstance()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> bindingIDs = new ArrayList<java.lang.String>();
  private ObjectReferenceBuilder secret;
  private ObjectReferenceBuilder templateInstance;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToBindingIDs(Integer index,java.lang.String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new java.util.ArrayList<java.lang.String>();}
    this.bindingIDs.add(index, item);
    return (A)this;
  }
  public A setToBindingIDs(java.lang.Integer index,java.lang.String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new java.util.ArrayList<java.lang.String>();}
    this.bindingIDs.set(index, item); return (A)this;
  }
  public A addToBindingIDs(java.lang.String... items) {
    if (this.bindingIDs == null) {this.bindingIDs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A addAllToBindingIDs(Collection<java.lang.String> items) {
    if (this.bindingIDs == null) {this.bindingIDs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A removeFromBindingIDs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.bindingIDs!= null){ this.bindingIDs.remove(item);}} return (A)this;
  }
  public A removeAllFromBindingIDs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.bindingIDs!= null){ this.bindingIDs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getBindingIDs() {
    return this.bindingIDs;
  }
  public java.lang.String getBindingID(java.lang.Integer index) {
    return this.bindingIDs.get(index);
  }
  public java.lang.String getFirstBindingID() {
    return this.bindingIDs.get(0);
  }
  public java.lang.String getLastBindingID() {
    return this.bindingIDs.get(bindingIDs.size() - 1);
  }
  public java.lang.String getMatchingBindingID(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: bindingIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBindingID(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: bindingIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBindingIDs(java.util.List<java.lang.String> bindingIDs) {
    if (bindingIDs != null) {this.bindingIDs = new java.util.ArrayList(); for (java.lang.String item : bindingIDs){this.addToBindingIDs(item);}} else { this.bindingIDs = null;} return (A) this;
  }
  public A withBindingIDs(java.lang.String... bindingIDs) {
    if (this.bindingIDs != null) {this.bindingIDs.clear();}
    if (bindingIDs != null) {for (java.lang.String item :bindingIDs){ this.addToBindingIDs(item);}} return (A) this;
  }
  public java.lang.Boolean hasBindingIDs() {
    return bindingIDs != null && !bindingIDs.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(io.fabric8.kubernetes.api.model.ObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
  }
  public java.lang.Boolean hasSecret() {
    return this.secret != null;
  }
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecret() {
    return new BrokerTemplateInstanceSpecFluentImpl.SecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new BrokerTemplateInstanceSpecFluentImpl.SecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplateInstance instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getTemplateInstance() {
    return this.templateInstance!=null ?this.templateInstance.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildTemplateInstance() {
    return this.templateInstance!=null ?this.templateInstance.build():null;
  }
  public A withTemplateInstance(io.fabric8.kubernetes.api.model.ObjectReference templateInstance) {
    _visitables.get("templateInstance").remove(this.templateInstance);
    if (templateInstance!=null){ this.templateInstance= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(templateInstance); _visitables.get("templateInstance").add(this.templateInstance);} return (A) this;
  }
  public java.lang.Boolean hasTemplateInstance() {
    return this.templateInstance != null;
  }
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstance() {
    return new BrokerTemplateInstanceSpecFluentImpl.TemplateInstanceNestedImpl();
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstanceLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluentImpl.TemplateInstanceNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editTemplateInstance() {
    return withNewTemplateInstanceLike(getTemplateInstance());
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstance() {
    return withNewTemplateInstanceLike(getTemplateInstance() != null ? getTemplateInstance(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstanceLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewTemplateInstanceLike(getTemplateInstance() != null ? getTemplateInstance(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BrokerTemplateInstanceSpecFluentImpl that = (BrokerTemplateInstanceSpecFluentImpl) o;
    if (bindingIDs != null ? !bindingIDs.equals(that.bindingIDs) :that.bindingIDs != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (templateInstance != null ? !templateInstance.equals(that.templateInstance) :that.templateInstance != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bindingIDs,  secret,  templateInstance,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindingIDs != null && !bindingIDs.isEmpty()) { sb.append("bindingIDs:"); sb.append(bindingIDs + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (templateInstance != null) { sb.append("templateInstance:"); sb.append(templateInstance + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretNestedImpl<N> extends ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.SecretNested<N>> implements io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.SecretNested<N>,Nested<N>{
    SecretNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class TemplateInstanceNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>> implements io.fabric8.openshift.api.model.BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateInstanceNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    TemplateInstanceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluentImpl.this.withTemplateInstance(builder.build());
    }
    public N endTemplateInstance() {
      return and();
    }
    
  }
  
}