package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildBuilder extends BuildFluentImpl<BuildBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Build,io.fabric8.openshift.api.model.BuildBuilder>{
  public BuildBuilder() {
    this(false);
  }
  public BuildBuilder(Boolean validationEnabled) {
    this(new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Build(), validationEnabled);
  }
  public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,io.fabric8.openshift.api.model.Build instance) {
    this(fluent, instance, false);
  }
  public BuildBuilder(io.fabric8.openshift.api.model.BuildFluent<?> fluent,io.fabric8.openshift.api.model.Build instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildBuilder(io.fabric8.openshift.api.model.Build instance) {
    this(instance,false);
  }
  public BuildBuilder(io.fabric8.openshift.api.model.Build instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Build build() {
    Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}