package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigBuilder extends BuildConfigFluentImpl<BuildConfigBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildConfig,BuildConfigBuilder>{
  public BuildConfigBuilder() {
    this(false);
  }
  public BuildConfigBuilder(Boolean validationEnabled) {
    this(new BuildConfig(), validationEnabled);
  }
  public BuildConfigBuilder(BuildConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildConfig(), validationEnabled);
  }
  public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfig instance) {
    this(fluent, instance, false);
  }
  public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfig instance) {
    this(instance,false);
  }
  public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildConfig build() {
    BuildConfig buildable = new BuildConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}