package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>> extends BaseFluent<A> implements BuildOutputFluent<A>{
  public BuildOutputFluentImpl() {
  }
  public BuildOutputFluentImpl(io.fabric8.openshift.api.model.BuildOutput instance) {
    this.withImageLabels(instance.getImageLabels()); 
    this.withPushSecret(instance.getPushSecret()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ImageLabelBuilder> imageLabels = new java.util.ArrayList<ImageLabelBuilder>();
  private LocalObjectReferenceBuilder pushSecret;
  private ObjectReferenceBuilder to;
  private Map<String,Object> additionalProperties;
  public A addToImageLabels(Integer index,io.fabric8.openshift.api.model.ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
    io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(index >= 0 ? index : _visitables.get("imageLabels").size(), builder);this.imageLabels.add(index >= 0 ? index : imageLabels.size(), builder); return (A)this;
  }
  public A setToImageLabels(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
    io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);
    if (index < 0 || index >= _visitables.get("imageLabels").size()) { _visitables.get("imageLabels").add(builder); } else { _visitables.get("imageLabels").set(index, builder);}
    if (index < 0 || index >= imageLabels.size()) { imageLabels.add(builder); } else { imageLabels.set(index, builder);}
     return (A)this;
  }
  public A addToImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
    if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
    for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A addAllToImageLabels(Collection<io.fabric8.openshift.api.model.ImageLabel> items) {
    if (this.imageLabels == null) {this.imageLabels = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLabelBuilder>();}
    for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A removeFromImageLabels(io.fabric8.openshift.api.model.ImageLabel... items) {
    for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageLabels(java.util.Collection<io.fabric8.openshift.api.model.ImageLabel> items) {
    for (io.fabric8.openshift.api.model.ImageLabel item : items) {io.fabric8.openshift.api.model.ImageLabelBuilder builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageLabels(Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
    if (imageLabels == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageLabelBuilder> each = imageLabels.iterator();
    final List visitables = _visitables.get("imageLabels");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.ImageLabel> getImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageLabel> buildImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public io.fabric8.openshift.api.model.ImageLabel buildImageLabel(java.lang.Integer index) {
    return this.imageLabels.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageLabel buildFirstImageLabel() {
    return this.imageLabels.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageLabel buildLastImageLabel() {
    return this.imageLabels.get(imageLabels.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageLabel buildMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageLabels(java.util.List<io.fabric8.openshift.api.model.ImageLabel> imageLabels) {
    if (this.imageLabels != null) { _visitables.get("imageLabels").removeAll(this.imageLabels);}
    if (imageLabels != null) {this.imageLabels = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageLabel item : imageLabels){this.addToImageLabels(item);}} else { this.imageLabels = null;} return (A) this;
  }
  public A withImageLabels(io.fabric8.openshift.api.model.ImageLabel... imageLabels) {
    if (this.imageLabels != null) {this.imageLabels.clear();}
    if (imageLabels != null) {for (io.fabric8.openshift.api.model.ImageLabel item :imageLabels){ this.addToImageLabels(item);}} return (A) this;
  }
  public java.lang.Boolean hasImageLabels() {
    return imageLabels != null && !imageLabels.isEmpty();
  }
  public A addNewImageLabel(java.lang.String name,java.lang.String value) {
    return (A)addToImageLabels(new ImageLabel(name, value));
  }
  public BuildOutputFluent.ImageLabelsNested<A> addNewImageLabel() {
    return new BuildOutputFluentImpl.ImageLabelsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> addNewImageLabelLike(io.fabric8.openshift.api.model.ImageLabel item) {
    return new BuildOutputFluentImpl.ImageLabelsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> setNewImageLabelLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLabel item) {
    return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ImageLabelsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editImageLabel(java.lang.Integer index) {
    if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editFirstImageLabel() {
    if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
    return setNewImageLabelLike(0, buildImageLabel(0));
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editLastImageLabel() {
    int index = imageLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<A> editMatchingImageLabel(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageLabels.size();i++) { 
    if (predicate.test(imageLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  /**
   * This method has been deprecated, please use method buildPushSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalObjectReference getPushSecret() {
    return this.pushSecret!=null ?this.pushSecret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildPushSecret() {
    return this.pushSecret!=null ?this.pushSecret.build():null;
  }
  public A withPushSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pushSecret) {
    _visitables.get("pushSecret").remove(this.pushSecret);
    if (pushSecret!=null){ this.pushSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pushSecret); _visitables.get("pushSecret").add(this.pushSecret);} return (A) this;
  }
  public java.lang.Boolean hasPushSecret() {
    return this.pushSecret != null;
  }
  public A withNewPushSecret(java.lang.String name) {
    return (A)withPushSecret(new LocalObjectReference(name));
  }
  public BuildOutputFluent.PushSecretNested<A> withNewPushSecret() {
    return new BuildOutputFluentImpl.PushSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.PushSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editPushSecret() {
    return withNewPushSecretLike(getPushSecret());
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret() {
    return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getTo() {
    return this.to!=null ?this.to.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} return (A) this;
  }
  public java.lang.Boolean hasTo() {
    return this.to != null;
  }
  public BuildOutputFluent.ToNested<A> withNewTo() {
    return new BuildOutputFluentImpl.ToNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> withNewToLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildOutputFluentImpl.ToNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editTo() {
    return withNewToLike(getTo());
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editOrNewTo() {
    return withNewToLike(getTo() != null ? getTo(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<A> editOrNewToLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewToLike(getTo() != null ? getTo(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildOutputFluentImpl that = (BuildOutputFluentImpl) o;
    if (imageLabels != null ? !imageLabels.equals(that.imageLabels) :that.imageLabels != null) return false;
    if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(imageLabels,  pushSecret,  to,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageLabels != null && !imageLabels.isEmpty()) { sb.append("imageLabels:"); sb.append(imageLabels + ","); }
    if (pushSecret != null) { sb.append("pushSecret:"); sb.append(pushSecret + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageLabelsNestedImpl<N> extends ImageLabelFluentImpl<BuildOutputFluent.ImageLabelsNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.ImageLabelsNested<N>,Nested<N>{
    ImageLabelsNestedImpl(java.lang.Integer index,ImageLabel item) {
      this.index = index;
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageLabelBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageLabelBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildOutputFluentImpl.this.setToImageLabels(index,builder.build());
    }
    public N endImageLabel() {
      return and();
    }
    
  }
  class PushSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<BuildOutputFluent.PushSecretNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.PushSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PushSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    PushSecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildOutputFluentImpl.this.withPushSecret(builder.build());
    }
    public N endPushSecret() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends ObjectReferenceFluentImpl<BuildOutputFluent.ToNested<N>> implements io.fabric8.openshift.api.model.BuildOutputFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ToNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    ToNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildOutputFluentImpl.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}