package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildSpec,BuildSpecBuilder>{
  public BuildSpecBuilder() {
    this(false);
  }
  public BuildSpecBuilder(Boolean validationEnabled) {
    this(new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildSpec instance) {
    this(fluent, instance, false);
  }
  public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
    fluent.withMountTrustedCA(instance.getMountTrustedCA()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withOutput(instance.getOutput()); 
    fluent.withPostCommit(instance.getPostCommit()); 
    fluent.withResources(instance.getResources()); 
    fluent.withRevision(instance.getRevision()); 
    fluent.withServiceAccount(instance.getServiceAccount()); 
    fluent.withSource(instance.getSource()); 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withTriggeredBy(instance.getTriggeredBy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpec instance) {
    this(instance,false);
  }
  public BuildSpecBuilder(io.fabric8.openshift.api.model.BuildSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
    this.withMountTrustedCA(instance.getMountTrustedCA()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withOutput(instance.getOutput()); 
    this.withPostCommit(instance.getPostCommit()); 
    this.withResources(instance.getResources()); 
    this.withRevision(instance.getRevision()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withSource(instance.getSource()); 
    this.withStrategy(instance.getStrategy()); 
    this.withTriggeredBy(instance.getTriggeredBy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildSpec build() {
    BuildSpec buildable = new BuildSpec(fluent.getCompletionDeadlineSeconds(),fluent.getMountTrustedCA(),fluent.getNodeSelector(),fluent.getOutput(),fluent.getPostCommit(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy(),fluent.getTriggeredBy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}