package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStatusBuilder extends BuildStatusFluentImpl<BuildStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildStatus,io.fabric8.openshift.api.model.BuildStatusBuilder>{
  public BuildStatusBuilder() {
    this(false);
  }
  public BuildStatusBuilder(Boolean validationEnabled) {
    this(new BuildStatus(), validationEnabled);
  }
  public BuildStatusBuilder(BuildStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildStatus(), validationEnabled);
  }
  public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatus instance) {
    this(fluent, instance, false);
  }
  public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCancelled(instance.getCancelled()); 
    fluent.withCompletionTimestamp(instance.getCompletionTimestamp()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConfig(instance.getConfig()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withLogSnippet(instance.getLogSnippet()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withOutput(instance.getOutput()); 
    fluent.withOutputDockerImageReference(instance.getOutputDockerImageReference()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStages(instance.getStages()); 
    fluent.withStartTimestamp(instance.getStartTimestamp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatus instance) {
    this(instance,false);
  }
  public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCancelled(instance.getCancelled()); 
    this.withCompletionTimestamp(instance.getCompletionTimestamp()); 
    this.withConditions(instance.getConditions()); 
    this.withConfig(instance.getConfig()); 
    this.withDuration(instance.getDuration()); 
    this.withLogSnippet(instance.getLogSnippet()); 
    this.withMessage(instance.getMessage()); 
    this.withOutput(instance.getOutput()); 
    this.withOutputDockerImageReference(instance.getOutputDockerImageReference()); 
    this.withPhase(instance.getPhase()); 
    this.withReason(instance.getReason()); 
    this.withStages(instance.getStages()); 
    this.withStartTimestamp(instance.getStartTimestamp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildStatus build() {
    BuildStatus buildable = new BuildStatus(fluent.getCancelled(),fluent.getCompletionTimestamp(),fluent.getConditions(),fluent.getConfig(),fluent.getDuration(),fluent.getLogSnippet(),fluent.getMessage(),fluent.getOutput(),fluent.getOutputDockerImageReference(),fluent.getPhase(),fluent.getReason(),fluent.getStages(),fluent.getStartTimestamp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}