package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStatusOutputToBuilder extends BuildStatusOutputToFluentImpl<BuildStatusOutputToBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.BuildStatusOutputTo,BuildStatusOutputToBuilder>{
  public BuildStatusOutputToBuilder() {
    this(false);
  }
  public BuildStatusOutputToBuilder(Boolean validationEnabled) {
    this(new BuildStatusOutputTo(), validationEnabled);
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputToFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputToFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildStatusOutputTo(), validationEnabled);
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputToFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatusOutputTo instance) {
    this(fluent, instance, false);
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputToFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatusOutputTo instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageDigest(instance.getImageDigest()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputTo instance) {
    this(instance,false);
  }
  public BuildStatusOutputToBuilder(io.fabric8.openshift.api.model.BuildStatusOutputTo instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageDigest(instance.getImageDigest()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildStatusOutputToFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildStatusOutputTo build() {
    BuildStatusOutputTo buildable = new BuildStatusOutputTo(fluent.getImageDigest());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}