package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStrategyBuilder extends BuildStrategyFluentImpl<BuildStrategyBuilder> implements VisitableBuilder<BuildStrategy,io.fabric8.openshift.api.model.BuildStrategyBuilder>{
  public BuildStrategyBuilder() {
    this(false);
  }
  public BuildStrategyBuilder(Boolean validationEnabled) {
    this(new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildStrategy(), validationEnabled);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.BuildStrategy instance) {
    this(fluent, instance, false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.BuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCustomStrategy(instance.getCustomStrategy()); 
    fluent.withDockerStrategy(instance.getDockerStrategy()); 
    fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
    fluent.withSourceStrategy(instance.getSourceStrategy()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategy instance) {
    this(instance,false);
  }
  public BuildStrategyBuilder(io.fabric8.openshift.api.model.BuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCustomStrategy(instance.getCustomStrategy()); 
    this.withDockerStrategy(instance.getDockerStrategy()); 
    this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
    this.withSourceStrategy(instance.getSourceStrategy()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildStrategy build() {
    BuildStrategy buildable = new BuildStrategy(fluent.getCustomStrategy(),fluent.getDockerStrategy(),fluent.getJenkinsPipelineStrategy(),fluent.getSourceStrategy(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}