package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildVolumeSourceBuilder extends BuildVolumeSourceFluentImpl<BuildVolumeSourceBuilder> implements VisitableBuilder<BuildVolumeSource,io.fabric8.openshift.api.model.BuildVolumeSourceBuilder>{
  public BuildVolumeSourceBuilder() {
    this(false);
  }
  public BuildVolumeSourceBuilder(Boolean validationEnabled) {
    this(new BuildVolumeSource(), validationEnabled);
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildVolumeSource(), validationEnabled);
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSourceFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolumeSource instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSourceFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSource instance) {
    this(instance,false);
  }
  public BuildVolumeSourceBuilder(io.fabric8.openshift.api.model.BuildVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withSecret(instance.getSecret()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildVolumeSource build() {
    BuildVolumeSource buildable = new BuildVolumeSource(fluent.getConfigMap(),fluent.getSecret(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}