package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterNetworkEntryBuilder extends ClusterNetworkEntryFluentImpl<ClusterNetworkEntryBuilder> implements VisitableBuilder<ClusterNetworkEntry,io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>{
  public ClusterNetworkEntryBuilder() {
    this(false);
  }
  public ClusterNetworkEntryBuilder(Boolean validationEnabled) {
    this(new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkEntry instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCidr(instance.getCidr()); 
    fluent.withHostSubnetLength(instance.getHostSubnetLength()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntry instance) {
    this(instance,false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCidr(instance.getCidr()); 
    this.withHostSubnetLength(instance.getHostSubnetLength()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterNetworkEntry build() {
    ClusterNetworkEntry buildable = new ClusterNetworkEntry(fluent.getCidr(),fluent.getHostSubnetLength());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}