package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterNetworkListBuilder extends ClusterNetworkListFluentImpl<ClusterNetworkListBuilder> implements VisitableBuilder<ClusterNetworkList,io.fabric8.openshift.api.model.ClusterNetworkListBuilder>{
  public ClusterNetworkListBuilder() {
    this(false);
  }
  public ClusterNetworkListBuilder(Boolean validationEnabled) {
    this(new ClusterNetworkList(), validationEnabled);
  }
  public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkListBuilder(io.fabric8.openshift.api.model.ClusterNetworkListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterNetworkList(), validationEnabled);
  }
  public ClusterNetworkListBuilder(io.fabric8.openshift.api.model.ClusterNetworkListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkList instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkListBuilder(io.fabric8.openshift.api.model.ClusterNetworkListFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkListBuilder(io.fabric8.openshift.api.model.ClusterNetworkList instance) {
    this(instance,false);
  }
  public ClusterNetworkListBuilder(io.fabric8.openshift.api.model.ClusterNetworkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterNetworkListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterNetworkList build() {
    ClusterNetworkList buildable = new ClusterNetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}