package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorBuilder extends ClusterOperatorFluentImpl<ClusterOperatorBuilder> implements VisitableBuilder<ClusterOperator,io.fabric8.openshift.api.model.ClusterOperatorBuilder>{
  public ClusterOperatorBuilder() {
    this(false);
  }
  public ClusterOperatorBuilder(Boolean validationEnabled) {
    this(new ClusterOperator(), validationEnabled);
  }
  public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorBuilder(io.fabric8.openshift.api.model.ClusterOperatorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterOperator(), validationEnabled);
  }
  public ClusterOperatorBuilder(io.fabric8.openshift.api.model.ClusterOperatorFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperator instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorBuilder(io.fabric8.openshift.api.model.ClusterOperatorFluent<?> fluent,io.fabric8.openshift.api.model.ClusterOperator instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorBuilder(io.fabric8.openshift.api.model.ClusterOperator instance) {
    this(instance,false);
  }
  public ClusterOperatorBuilder(io.fabric8.openshift.api.model.ClusterOperator instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterOperatorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterOperator build() {
    ClusterOperator buildable = new ClusterOperator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}