package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBuilder extends ClusterRoleFluentImpl<ClusterRoleBuilder> implements VisitableBuilder<ClusterRole,io.fabric8.openshift.api.model.ClusterRoleBuilder>{
  public ClusterRoleBuilder() {
    this(false);
  }
  public ClusterRoleBuilder(Boolean validationEnabled) {
    this(new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBuilder(io.fabric8.openshift.api.model.ClusterRoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(io.fabric8.openshift.api.model.ClusterRoleFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRole instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBuilder(io.fabric8.openshift.api.model.ClusterRoleFluent<?> fluent,io.fabric8.openshift.api.model.ClusterRole instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAggregationRule(instance.getAggregationRule()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBuilder(io.fabric8.openshift.api.model.ClusterRole instance) {
    this(instance,false);
  }
  public ClusterRoleBuilder(io.fabric8.openshift.api.model.ClusterRole instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAggregationRule(instance.getAggregationRule()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterRoleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterRole build() {
    ClusterRole buildable = new ClusterRole(fluent.getAggregationRule(),fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}