package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterRoleScopeRestrictionFluentImpl<A extends ClusterRoleScopeRestrictionFluent<A>> extends BaseFluent<A> implements ClusterRoleScopeRestrictionFluent<A>{
  public ClusterRoleScopeRestrictionFluentImpl() {
  }
  public ClusterRoleScopeRestrictionFluentImpl(io.fabric8.openshift.api.model.ClusterRoleScopeRestriction instance) {
    this.withAllowEscalation(instance.getAllowEscalation()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withRoleNames(instance.getRoleNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean allowEscalation;
  private List<String> namespaces = new ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> roleNames = new java.util.ArrayList<java.lang.String>();
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.Boolean getAllowEscalation() {
    return this.allowEscalation;
  }
  public A withAllowEscalation(java.lang.Boolean allowEscalation) {
    this.allowEscalation=allowEscalation; return (A) this;
  }
  public java.lang.Boolean hasAllowEscalation() {
    return this.allowEscalation != null;
  }
  public A addToNamespaces(Integer index,java.lang.String item) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    this.namespaces.add(index, item);
    return (A)this;
  }
  public A setToNamespaces(java.lang.Integer index,java.lang.String item) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    this.namespaces.set(index, item); return (A)this;
  }
  public A addToNamespaces(java.lang.String... items) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A addAllToNamespaces(Collection<java.lang.String> items) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A removeFromNamespaces(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public A removeAllFromNamespaces(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getNamespaces() {
    return this.namespaces;
  }
  public java.lang.String getNamespace(java.lang.Integer index) {
    return this.namespaces.get(index);
  }
  public java.lang.String getFirstNamespace() {
    return this.namespaces.get(0);
  }
  public java.lang.String getLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1);
  }
  public java.lang.String getMatchingNamespace(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingNamespace(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(java.util.List<java.lang.String> namespaces) {
    if (namespaces != null) {this.namespaces = new java.util.ArrayList(); for (java.lang.String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(java.lang.String... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear();}
    if (namespaces != null) {for (java.lang.String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public java.lang.Boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  public A addToRoleNames(java.lang.Integer index,java.lang.String item) {
    if (this.roleNames == null) {this.roleNames = new java.util.ArrayList<java.lang.String>();}
    this.roleNames.add(index, item);
    return (A)this;
  }
  public A setToRoleNames(java.lang.Integer index,java.lang.String item) {
    if (this.roleNames == null) {this.roleNames = new java.util.ArrayList<java.lang.String>();}
    this.roleNames.set(index, item); return (A)this;
  }
  public A addToRoleNames(java.lang.String... items) {
    if (this.roleNames == null) {this.roleNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.roleNames.add(item);} return (A)this;
  }
  public A addAllToRoleNames(java.util.Collection<java.lang.String> items) {
    if (this.roleNames == null) {this.roleNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.roleNames.add(item);} return (A)this;
  }
  public A removeFromRoleNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.roleNames!= null){ this.roleNames.remove(item);}} return (A)this;
  }
  public A removeAllFromRoleNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.roleNames!= null){ this.roleNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getRoleNames() {
    return this.roleNames;
  }
  public java.lang.String getRoleName(java.lang.Integer index) {
    return this.roleNames.get(index);
  }
  public java.lang.String getFirstRoleName() {
    return this.roleNames.get(0);
  }
  public java.lang.String getLastRoleName() {
    return this.roleNames.get(roleNames.size() - 1);
  }
  public java.lang.String getMatchingRoleName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: roleNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingRoleName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: roleNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoleNames(java.util.List<java.lang.String> roleNames) {
    if (roleNames != null) {this.roleNames = new java.util.ArrayList(); for (java.lang.String item : roleNames){this.addToRoleNames(item);}} else { this.roleNames = null;} return (A) this;
  }
  public A withRoleNames(java.lang.String... roleNames) {
    if (this.roleNames != null) {this.roleNames.clear();}
    if (roleNames != null) {for (java.lang.String item :roleNames){ this.addToRoleNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasRoleNames() {
    return roleNames != null && !roleNames.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl) o;
    if (allowEscalation != null ? !allowEscalation.equals(that.allowEscalation) :that.allowEscalation != null) return false;
    if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
    if (roleNames != null ? !roleNames.equals(that.roleNames) :that.roleNames != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowEscalation,  namespaces,  roleNames,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowEscalation != null) { sb.append("allowEscalation:"); sb.append(allowEscalation + ","); }
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (roleNames != null && !roleNames.isEmpty()) { sb.append("roleNames:"); sb.append(roleNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowEscalation() {
    return withAllowEscalation(true);
  }
  
}