package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionBuilder extends ClusterVersionFluentImpl<ClusterVersionBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ClusterVersion,ClusterVersionBuilder>{
  public ClusterVersionBuilder() {
    this(false);
  }
  public ClusterVersionBuilder(Boolean validationEnabled) {
    this(new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(ClusterVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterVersion(), validationEnabled);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersion instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent,io.fabric8.openshift.api.model.ClusterVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersion instance) {
    this(instance,false);
  }
  public ClusterVersionBuilder(io.fabric8.openshift.api.model.ClusterVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterVersionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterVersion build() {
    ClusterVersion buildable = new ClusterVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}