package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentRouteStatusBuilder extends ComponentRouteStatusFluentImpl<ComponentRouteStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ComponentRouteStatus,io.fabric8.openshift.api.model.ComponentRouteStatusBuilder>{
  public ComponentRouteStatusBuilder() {
    this(false);
  }
  public ComponentRouteStatusBuilder(Boolean validationEnabled) {
    this(new ComponentRouteStatus(), validationEnabled);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentRouteStatusBuilder(io.fabric8.openshift.api.model.ComponentRouteStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ComponentRouteStatus(), validationEnabled);
  }
  public ComponentRouteStatusBuilder(io.fabric8.openshift.api.model.ComponentRouteStatusFluent<?> fluent,io.fabric8.openshift.api.model.ComponentRouteStatus instance) {
    this(fluent, instance, false);
  }
  public ComponentRouteStatusBuilder(io.fabric8.openshift.api.model.ComponentRouteStatusFluent<?> fluent,io.fabric8.openshift.api.model.ComponentRouteStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConsumingUsers(instance.getConsumingUsers()); 
    fluent.withCurrentHostnames(instance.getCurrentHostnames()); 
    fluent.withDefaultHostname(instance.getDefaultHostname()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withRelatedObjects(instance.getRelatedObjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ComponentRouteStatusBuilder(io.fabric8.openshift.api.model.ComponentRouteStatus instance) {
    this(instance,false);
  }
  public ComponentRouteStatusBuilder(io.fabric8.openshift.api.model.ComponentRouteStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withConsumingUsers(instance.getConsumingUsers()); 
    this.withCurrentHostnames(instance.getCurrentHostnames()); 
    this.withDefaultHostname(instance.getDefaultHostname()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withRelatedObjects(instance.getRelatedObjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ComponentRouteStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ComponentRouteStatus build() {
    ComponentRouteStatus buildable = new ComponentRouteStatus(fluent.getConditions(),fluent.getConsumingUsers(),fluent.getCurrentHostnames(),fluent.getDefaultHostname(),fluent.getName(),fluent.getNamespace(),fluent.getRelatedObjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}