package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapFileReferenceBuilder extends ConfigMapFileReferenceFluentImpl<ConfigMapFileReferenceBuilder> implements VisitableBuilder<ConfigMapFileReference,io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder>{
  public ConfigMapFileReferenceBuilder() {
    this(false);
  }
  public ConfigMapFileReferenceBuilder(Boolean validationEnabled) {
    this(new ConfigMapFileReference(), validationEnabled);
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapFileReference(), validationEnabled);
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ConfigMapFileReference instance) {
    this(fluent, instance, false);
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ConfigMapFileReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReference instance) {
    this(instance,false);
  }
  public ConfigMapFileReferenceBuilder(io.fabric8.openshift.api.model.ConfigMapFileReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConfigMapFileReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConfigMapFileReference build() {
    ConfigMapFileReference buildable = new ConfigMapFileReference(fluent.getKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}