package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleAuthenticationBuilder extends ConsoleAuthenticationFluentImpl<ConsoleAuthenticationBuilder> implements VisitableBuilder<ConsoleAuthentication,io.fabric8.openshift.api.model.ConsoleAuthenticationBuilder>{
  public ConsoleAuthenticationBuilder() {
    this(false);
  }
  public ConsoleAuthenticationBuilder(Boolean validationEnabled) {
    this(new ConsoleAuthentication(), validationEnabled);
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthenticationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleAuthentication(), validationEnabled);
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthenticationFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleAuthentication instance) {
    this(fluent, instance, false);
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthenticationFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleAuthentication instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLogoutRedirect(instance.getLogoutRedirect()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthentication instance) {
    this(instance,false);
  }
  public ConsoleAuthenticationBuilder(io.fabric8.openshift.api.model.ConsoleAuthentication instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLogoutRedirect(instance.getLogoutRedirect()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleAuthenticationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleAuthentication build() {
    ConsoleAuthentication buildable = new ConsoleAuthentication(fluent.getLogoutRedirect());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}