package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleListBuilder extends ConsoleListFluentImpl<ConsoleListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ConsoleList,io.fabric8.openshift.api.model.ConsoleListBuilder>{
  public ConsoleListBuilder() {
    this(false);
  }
  public ConsoleListBuilder(Boolean validationEnabled) {
    this(new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(ConsoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleList instance) {
    this(fluent, instance, false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleList instance) {
    this(instance,false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleList build() {
    ConsoleList buildable = new ConsoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}