package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomBuildStrategyBuilder extends CustomBuildStrategyFluentImpl<CustomBuildStrategyBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.CustomBuildStrategy,io.fabric8.openshift.api.model.CustomBuildStrategyBuilder>{
  public CustomBuildStrategyBuilder() {
    this(false);
  }
  public CustomBuildStrategyBuilder(Boolean validationEnabled) {
    this(new CustomBuildStrategy(), validationEnabled);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CustomBuildStrategy(), validationEnabled);
  }
  public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.CustomBuildStrategy instance) {
    this(fluent, instance, false);
  }
  public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.CustomBuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBuildAPIVersion(instance.getBuildAPIVersion()); 
    fluent.withEnv(instance.getEnv()); 
    fluent.withExposeDockerSocket(instance.getExposeDockerSocket()); 
    fluent.withForcePull(instance.getForcePull()); 
    fluent.withFrom(instance.getFrom()); 
    fluent.withPullSecret(instance.getPullSecret()); 
    fluent.withSecrets(instance.getSecrets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategy instance) {
    this(instance,false);
  }
  public CustomBuildStrategyBuilder(io.fabric8.openshift.api.model.CustomBuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBuildAPIVersion(instance.getBuildAPIVersion()); 
    this.withEnv(instance.getEnv()); 
    this.withExposeDockerSocket(instance.getExposeDockerSocket()); 
    this.withForcePull(instance.getForcePull()); 
    this.withFrom(instance.getFrom()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withSecrets(instance.getSecrets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.CustomBuildStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.CustomBuildStrategy build() {
    CustomBuildStrategy buildable = new CustomBuildStrategy(fluent.getBuildAPIVersion(),fluent.getEnv(),fluent.getExposeDockerSocket(),fluent.getForcePull(),fluent.getFrom(),fluent.getPullSecret(),fluent.getSecrets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}