package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomDeploymentStrategyParamsBuilder extends CustomDeploymentStrategyParamsFluentImpl<CustomDeploymentStrategyParamsBuilder> implements VisitableBuilder<CustomDeploymentStrategyParams,io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsBuilder>{
  public CustomDeploymentStrategyParamsBuilder() {
    this(false);
  }
  public CustomDeploymentStrategyParamsBuilder(Boolean validationEnabled) {
    this(new CustomDeploymentStrategyParams(), validationEnabled);
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CustomDeploymentStrategyParams(), validationEnabled);
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.CustomDeploymentStrategyParams instance) {
    this(fluent, instance, false);
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.CustomDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommand(instance.getCommand()); 
    fluent.withEnvironment(instance.getEnvironment()); 
    fluent.withImage(instance.getImage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParams instance) {
    this(instance,false);
  }
  public CustomDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.CustomDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommand(instance.getCommand()); 
    this.withEnvironment(instance.getEnvironment()); 
    this.withImage(instance.getImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.CustomDeploymentStrategyParams build() {
    CustomDeploymentStrategyParams buildable = new CustomDeploymentStrategyParams(fluent.getCommand(),fluent.getEnvironment(),fluent.getImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}