package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSListBuilder extends DNSListFluentImpl<DNSListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DNSList,io.fabric8.openshift.api.model.DNSListBuilder>{
  public DNSListBuilder() {
    this(false);
  }
  public DNSListBuilder(Boolean validationEnabled) {
    this(new DNSList(), validationEnabled);
  }
  public DNSListBuilder(DNSListFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSListBuilder(io.fabric8.openshift.api.model.DNSListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DNSList(), validationEnabled);
  }
  public DNSListBuilder(io.fabric8.openshift.api.model.DNSListFluent<?> fluent,io.fabric8.openshift.api.model.DNSList instance) {
    this(fluent, instance, false);
  }
  public DNSListBuilder(io.fabric8.openshift.api.model.DNSListFluent<?> fluent,io.fabric8.openshift.api.model.DNSList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSListBuilder(io.fabric8.openshift.api.model.DNSList instance) {
    this(instance,false);
  }
  public DNSListBuilder(io.fabric8.openshift.api.model.DNSList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DNSListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DNSList build() {
    DNSList buildable = new DNSList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}