package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSSpecBuilder extends DNSSpecFluentImpl<DNSSpecBuilder> implements VisitableBuilder<DNSSpec,io.fabric8.openshift.api.model.DNSSpecBuilder>{
  public DNSSpecBuilder() {
    this(false);
  }
  public DNSSpecBuilder(Boolean validationEnabled) {
    this(new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSSpecBuilder(io.fabric8.openshift.api.model.DNSSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(io.fabric8.openshift.api.model.DNSSpecFluent<?> fluent,io.fabric8.openshift.api.model.DNSSpec instance) {
    this(fluent, instance, false);
  }
  public DNSSpecBuilder(io.fabric8.openshift.api.model.DNSSpecFluent<?> fluent,io.fabric8.openshift.api.model.DNSSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseDomain(instance.getBaseDomain()); 
    fluent.withPrivateZone(instance.getPrivateZone()); 
    fluent.withPublicZone(instance.getPublicZone()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSSpecBuilder(io.fabric8.openshift.api.model.DNSSpec instance) {
    this(instance,false);
  }
  public DNSSpecBuilder(io.fabric8.openshift.api.model.DNSSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withPrivateZone(instance.getPrivateZone()); 
    this.withPublicZone(instance.getPublicZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DNSSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DNSSpec build() {
    DNSSpec buildable = new DNSSpec(fluent.getBaseDomain(),fluent.getPrivateZone(),fluent.getPublicZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}