package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigBuilder extends DeploymentConfigFluentImpl<DeploymentConfigBuilder> implements VisitableBuilder<DeploymentConfig,io.fabric8.openshift.api.model.DeploymentConfigBuilder>{
  public DeploymentConfigBuilder() {
    this(false);
  }
  public DeploymentConfigBuilder(Boolean validationEnabled) {
    this(new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfig instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfig instance) {
    this(instance,false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentConfig build() {
    DeploymentConfig buildable = new DeploymentConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}