package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigSpecBuilder extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder> implements VisitableBuilder<DeploymentConfigSpec,io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder>{
  public DeploymentConfigSpecBuilder() {
    this(false);
  }
  public DeploymentConfigSpecBuilder(Boolean validationEnabled) {
    this(new DeploymentConfigSpec(), validationEnabled);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentConfigSpec(), validationEnabled);
  }
  public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigSpec instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTest(instance.getTest()); 
    fluent.withTriggers(instance.getTriggers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpec instance) {
    this(instance,false);
  }
  public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withStrategy(instance.getStrategy()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTest(instance.getTest()); 
    this.withTriggers(instance.getTriggers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentConfigSpec build() {
    DeploymentConfigSpec buildable = new DeploymentConfigSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.getTest(),fluent.getTriggers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}