package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentTriggerPolicyBuilder extends DeploymentTriggerPolicyFluentImpl<DeploymentTriggerPolicyBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DeploymentTriggerPolicy,DeploymentTriggerPolicyBuilder>{
  public DeploymentTriggerPolicyBuilder() {
    this(false);
  }
  public DeploymentTriggerPolicyBuilder(Boolean validationEnabled) {
    this(new DeploymentTriggerPolicy(), validationEnabled);
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentTriggerPolicy(), validationEnabled);
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentTriggerPolicy instance) {
    this(fluent, instance, false);
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentTriggerPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageChangeParams(instance.getImageChangeParams()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicy instance) {
    this(instance,false);
  }
  public DeploymentTriggerPolicyBuilder(io.fabric8.openshift.api.model.DeploymentTriggerPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageChangeParams(instance.getImageChangeParams()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentTriggerPolicy build() {
    DeploymentTriggerPolicy buildable = new DeploymentTriggerPolicy(fluent.getImageChangeParams(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}