package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicyPeerBuilder extends EgressNetworkPolicyPeerFluentImpl<EgressNetworkPolicyPeerBuilder> implements VisitableBuilder<EgressNetworkPolicyPeer,io.fabric8.openshift.api.model.EgressNetworkPolicyPeerBuilder>{
  public EgressNetworkPolicyPeerBuilder() {
    this(false);
  }
  public EgressNetworkPolicyPeerBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicyPeer(), validationEnabled);
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicyPeer(), validationEnabled);
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCidrSelector(instance.getCidrSelector()); 
    fluent.withDnsName(instance.getDnsName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance) {
    this(instance,false);
  }
  public EgressNetworkPolicyPeerBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCidrSelector(instance.getCidrSelector()); 
    this.withDnsName(instance.getDnsName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.EgressNetworkPolicyPeerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.EgressNetworkPolicyPeer build() {
    EgressNetworkPolicyPeer buildable = new EgressNetworkPolicyPeer(fluent.getCidrSelector(),fluent.getDnsName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}