package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EgressNetworkPolicySpecFluentImpl<A extends EgressNetworkPolicySpecFluent<A>> extends BaseFluent<A> implements EgressNetworkPolicySpecFluent<A>{
  public EgressNetworkPolicySpecFluentImpl() {
  }
  public EgressNetworkPolicySpecFluentImpl(io.fabric8.openshift.api.model.EgressNetworkPolicySpec instance) {
    this.withEgress(instance.getEgress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<EgressNetworkPolicyRuleBuilder> egress = new java.util.ArrayList<EgressNetworkPolicyRuleBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToEgress(Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicyRule item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder>();}
    io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
  }
  public A setToEgress(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicyRule item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder>();}
    io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
    if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
     return (A)this;
  }
  public A addToEgress(io.fabric8.openshift.api.model.EgressNetworkPolicyRule... items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder>();}
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A addAllToEgress(Collection<io.fabric8.openshift.api.model.EgressNetworkPolicyRule> items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder>();}
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A removeFromEgress(io.fabric8.openshift.api.model.EgressNetworkPolicyRule... items) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeAllFromEgress(java.util.Collection<io.fabric8.openshift.api.model.EgressNetworkPolicyRule> items) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEgress(Predicate<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder> predicate) {
    if (egress == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder> each = egress.iterator();
    final List visitables = _visitables.get("egress");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEgress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.EgressNetworkPolicyRule> getEgress() {
    return egress != null ? build(egress) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.EgressNetworkPolicyRule> buildEgress() {
    return egress != null ? build(egress) : null;
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicyRule buildEgress(java.lang.Integer index) {
    return this.egress.get(index).build();
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicyRule buildFirstEgress() {
    return this.egress.get(0).build();
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicyRule buildLastEgress() {
    return this.egress.get(egress.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicyRule buildMatchingEgress(java.util.function.Predicate<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder> predicate) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder item: egress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEgress(java.util.function.Predicate<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder> predicate) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder item: egress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgress(java.util.List<io.fabric8.openshift.api.model.EgressNetworkPolicyRule> egress) {
    if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
    if (egress != null) {this.egress = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
  }
  public A withEgress(io.fabric8.openshift.api.model.EgressNetworkPolicyRule... egress) {
    if (this.egress != null) {this.egress.clear();}
    if (egress != null) {for (io.fabric8.openshift.api.model.EgressNetworkPolicyRule item :egress){ this.addToEgress(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgress() {
    return egress != null && !egress.isEmpty();
  }
  public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
    return new EgressNetworkPolicySpecFluentImpl.EgressNestedImpl();
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(io.fabric8.openshift.api.model.EgressNetworkPolicyRule item) {
    return new EgressNetworkPolicySpecFluentImpl.EgressNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicyRule item) {
    return new io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluentImpl.EgressNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> editEgress(java.lang.Integer index) {
    if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
    if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
    return setNewEgressLike(0, buildEgress(0));
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
    int index = egress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(java.util.function.Predicate<io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<egress.size();i++) { 
    if (predicate.test(egress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EgressNetworkPolicySpecFluentImpl that = (EgressNetworkPolicySpecFluentImpl) o;
    if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(egress,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egress != null && !egress.isEmpty()) { sb.append("egress:"); sb.append(egress + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EgressNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<EgressNetworkPolicySpecFluent.EgressNested<N>> implements io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent.EgressNested<N>,Nested<N>{
    EgressNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicyRule item) {
      this.index = index;
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder(this);
    }
    io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EgressNetworkPolicySpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress() {
      return and();
    }
    
  }
  
}