package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecNewPodHookBuilder extends ExecNewPodHookFluentImpl<ExecNewPodHookBuilder> implements VisitableBuilder<ExecNewPodHook,io.fabric8.openshift.api.model.ExecNewPodHookBuilder>{
  public ExecNewPodHookBuilder() {
    this(false);
  }
  public ExecNewPodHookBuilder(Boolean validationEnabled) {
    this(new ExecNewPodHook(), validationEnabled);
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExecNewPodHook(), validationEnabled);
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,io.fabric8.openshift.api.model.ExecNewPodHook instance) {
    this(fluent, instance, false);
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,io.fabric8.openshift.api.model.ExecNewPodHook instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommand(instance.getCommand()); 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withEnv(instance.getEnv()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHook instance) {
    this(instance,false);
  }
  public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHook instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommand(instance.getCommand()); 
    this.withContainerName(instance.getContainerName()); 
    this.withEnv(instance.getEnv()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ExecNewPodHook build() {
    ExecNewPodHook buildable = new ExecNewPodHook(fluent.getCommand(),fluent.getContainerName(),fluent.getEnv(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}