package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalIPPolicyBuilder extends ExternalIPPolicyFluentImpl<ExternalIPPolicyBuilder> implements VisitableBuilder<ExternalIPPolicy,io.fabric8.openshift.api.model.ExternalIPPolicyBuilder>{
  public ExternalIPPolicyBuilder() {
    this(false);
  }
  public ExternalIPPolicyBuilder(Boolean validationEnabled) {
    this(new ExternalIPPolicy(), validationEnabled);
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExternalIPPolicy(), validationEnabled);
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicyFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPPolicy instance) {
    this(fluent, instance, false);
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicyFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowedCIDRs(instance.getAllowedCIDRs()); 
    fluent.withRejectedCIDRs(instance.getRejectedCIDRs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicy instance) {
    this(instance,false);
  }
  public ExternalIPPolicyBuilder(io.fabric8.openshift.api.model.ExternalIPPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowedCIDRs(instance.getAllowedCIDRs()); 
    this.withRejectedCIDRs(instance.getRejectedCIDRs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ExternalIPPolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ExternalIPPolicy build() {
    ExternalIPPolicy buildable = new ExternalIPPolicy(fluent.getAllowedCIDRs(),fluent.getRejectedCIDRs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}