package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateBuilder extends FeatureGateFluentImpl<FeatureGateBuilder> implements VisitableBuilder<FeatureGate,io.fabric8.openshift.api.model.FeatureGateBuilder>{
  public FeatureGateBuilder() {
    this(false);
  }
  public FeatureGateBuilder(Boolean validationEnabled) {
    this(new FeatureGate(), validationEnabled);
  }
  public FeatureGateBuilder(FeatureGateFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateBuilder(io.fabric8.openshift.api.model.FeatureGateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FeatureGate(), validationEnabled);
  }
  public FeatureGateBuilder(io.fabric8.openshift.api.model.FeatureGateFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGate instance) {
    this(fluent, instance, false);
  }
  public FeatureGateBuilder(io.fabric8.openshift.api.model.FeatureGateFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateBuilder(io.fabric8.openshift.api.model.FeatureGate instance) {
    this(instance,false);
  }
  public FeatureGateBuilder(io.fabric8.openshift.api.model.FeatureGate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.FeatureGateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.FeatureGate build() {
    FeatureGate buildable = new FeatureGate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}