package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateSpecBuilder extends FeatureGateSpecFluentImpl<FeatureGateSpecBuilder> implements VisitableBuilder<FeatureGateSpec,io.fabric8.openshift.api.model.FeatureGateSpecBuilder>{
  public FeatureGateSpecBuilder() {
    this(false);
  }
  public FeatureGateSpecBuilder(Boolean validationEnabled) {
    this(new FeatureGateSpec(), validationEnabled);
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FeatureGateSpec(), validationEnabled);
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpecFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateSpec instance) {
    this(fluent, instance, false);
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpecFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
    fluent.withFeatureSet(instance.getFeatureSet()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpec instance) {
    this(instance,false);
  }
  public FeatureGateSpecBuilder(io.fabric8.openshift.api.model.FeatureGateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
    this.withFeatureSet(instance.getFeatureSet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.FeatureGateSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.FeatureGateSpec build() {
    FeatureGateSpec buildable = new FeatureGateSpec(fluent.getCustomNoUpgrade(),fluent.getFeatureSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}