package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPPlatformStatusBuilder extends GCPPlatformStatusFluentImpl<GCPPlatformStatusBuilder> implements VisitableBuilder<GCPPlatformStatus,io.fabric8.openshift.api.model.GCPPlatformStatusBuilder>{
  public GCPPlatformStatusBuilder() {
    this(false);
  }
  public GCPPlatformStatusBuilder(Boolean validationEnabled) {
    this(new GCPPlatformStatus(), validationEnabled);
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GCPPlatformStatus(), validationEnabled);
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.GCPPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.GCPPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withProjectID(instance.getProjectID()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatus instance) {
    this(instance,false);
  }
  public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withProjectID(instance.getProjectID()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GCPPlatformStatus build() {
    GCPPlatformStatus buildable = new GCPPlatformStatus(fluent.getProjectID(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}