package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabWebHookCauseBuilder extends GitLabWebHookCauseFluentImpl<GitLabWebHookCauseBuilder> implements VisitableBuilder<GitLabWebHookCause,io.fabric8.openshift.api.model.GitLabWebHookCauseBuilder>{
  public GitLabWebHookCauseBuilder() {
    this(false);
  }
  public GitLabWebHookCauseBuilder(Boolean validationEnabled) {
    this(new GitLabWebHookCause(), validationEnabled);
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCauseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitLabWebHookCause(), validationEnabled);
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCauseFluent<?> fluent,io.fabric8.openshift.api.model.GitLabWebHookCause instance) {
    this(fluent, instance, false);
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCauseFluent<?> fluent,io.fabric8.openshift.api.model.GitLabWebHookCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRevision(instance.getRevision()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCause instance) {
    this(instance,false);
  }
  public GitLabWebHookCauseBuilder(io.fabric8.openshift.api.model.GitLabWebHookCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRevision(instance.getRevision()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GitLabWebHookCauseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GitLabWebHookCause build() {
    GitLabWebHookCause buildable = new GitLabWebHookCause(fluent.getRevision(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}