package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GoogleIdentityProviderFluentImpl<A extends GoogleIdentityProviderFluent<A>> extends BaseFluent<A> implements GoogleIdentityProviderFluent<A>{
  public GoogleIdentityProviderFluentImpl() {
  }
  public GoogleIdentityProviderFluentImpl(io.fabric8.openshift.api.model.GoogleIdentityProvider instance) {
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostedDomain(instance.getHostedDomain()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String clientID;
  private SecretNameReferenceBuilder clientSecret;
  private java.lang.String hostedDomain;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getClientID() {
    return this.clientID;
  }
  public A withClientID(java.lang.String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public io.fabric8.openshift.api.model.SecretNameReference buildClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public A withClientSecret(io.fabric8.openshift.api.model.SecretNameReference clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
  }
  public java.lang.Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(java.lang.String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
    return new GoogleIdentityProviderFluentImpl.ClientSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return new GoogleIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.GoogleIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(getClientSecret());
  }
  public io.fabric8.openshift.api.model.GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.fabric8.openshift.api.model.SecretNameReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
  }
  public java.lang.String getHostedDomain() {
    return this.hostedDomain;
  }
  public A withHostedDomain(java.lang.String hostedDomain) {
    this.hostedDomain=hostedDomain; return (A) this;
  }
  public java.lang.Boolean hasHostedDomain() {
    return this.hostedDomain != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleIdentityProviderFluentImpl that = (GoogleIdentityProviderFluentImpl) o;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (hostedDomain != null ? !hostedDomain.equals(that.hostedDomain) :that.hostedDomain != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientID,  clientSecret,  hostedDomain,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (hostedDomain != null) { sb.append("hostedDomain:"); sb.append(hostedDomain + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<GoogleIdentityProviderFluent.ClientSecretNested<N>> implements io.fabric8.openshift.api.model.GoogleIdentityProviderFluent.ClientSecretNested<N>,Nested<N>{
    ClientSecretNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    ClientSecretNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.SecretNameReferenceBuilder builder;
    public N and() {
      return (N) GoogleIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  
}