package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupBuilder extends GroupFluentImpl<GroupBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Group,io.fabric8.openshift.api.model.GroupBuilder>{
  public GroupBuilder() {
    this(false);
  }
  public GroupBuilder(Boolean validationEnabled) {
    this(new Group(), validationEnabled);
  }
  public GroupBuilder(GroupFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupBuilder(io.fabric8.openshift.api.model.GroupFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Group(), validationEnabled);
  }
  public GroupBuilder(io.fabric8.openshift.api.model.GroupFluent<?> fluent,io.fabric8.openshift.api.model.Group instance) {
    this(fluent, instance, false);
  }
  public GroupBuilder(io.fabric8.openshift.api.model.GroupFluent<?> fluent,io.fabric8.openshift.api.model.Group instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withUsers(instance.getUsers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupBuilder(io.fabric8.openshift.api.model.Group instance) {
    this(instance,false);
  }
  public GroupBuilder(io.fabric8.openshift.api.model.Group instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GroupFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Group build() {
    Group buildable = new Group(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}