package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupListBuilder extends GroupListFluentImpl<GroupListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.GroupList,GroupListBuilder>{
  public GroupListBuilder() {
    this(false);
  }
  public GroupListBuilder(Boolean validationEnabled) {
    this(new GroupList(), validationEnabled);
  }
  public GroupListBuilder(GroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupList(), validationEnabled);
  }
  public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,io.fabric8.openshift.api.model.GroupList instance) {
    this(fluent, instance, false);
  }
  public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,io.fabric8.openshift.api.model.GroupList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupListBuilder(io.fabric8.openshift.api.model.GroupList instance) {
    this(instance,false);
  }
  public GroupListBuilder(io.fabric8.openshift.api.model.GroupList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GroupListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GroupList build() {
    GroupList buildable = new GroupList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}