package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositoryBuilder extends HelmChartRepositoryFluentImpl<HelmChartRepositoryBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.HelmChartRepository,io.fabric8.openshift.api.model.HelmChartRepositoryBuilder>{
  public HelmChartRepositoryBuilder() {
    this(false);
  }
  public HelmChartRepositoryBuilder(Boolean validationEnabled) {
    this(new HelmChartRepository(), validationEnabled);
  }
  public HelmChartRepositoryBuilder(HelmChartRepositoryFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositoryBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HelmChartRepository(), validationEnabled);
  }
  public HelmChartRepositoryBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepository instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositoryBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepository instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositoryBuilder(io.fabric8.openshift.api.model.HelmChartRepository instance) {
    this(instance,false);
  }
  public HelmChartRepositoryBuilder(io.fabric8.openshift.api.model.HelmChartRepository instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HelmChartRepositoryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HelmChartRepository build() {
    HelmChartRepository buildable = new HelmChartRepository(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}