package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositorySpecBuilder extends HelmChartRepositorySpecFluentImpl<HelmChartRepositorySpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.HelmChartRepositorySpec,io.fabric8.openshift.api.model.HelmChartRepositorySpecBuilder>{
  public HelmChartRepositorySpecBuilder() {
    this(false);
  }
  public HelmChartRepositorySpecBuilder(Boolean validationEnabled) {
    this(new HelmChartRepositorySpec(), validationEnabled);
  }
  public HelmChartRepositorySpecBuilder(HelmChartRepositorySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositorySpecBuilder(io.fabric8.openshift.api.model.HelmChartRepositorySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HelmChartRepositorySpec(), validationEnabled);
  }
  public HelmChartRepositorySpecBuilder(io.fabric8.openshift.api.model.HelmChartRepositorySpecFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepositorySpec instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositorySpecBuilder(io.fabric8.openshift.api.model.HelmChartRepositorySpecFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepositorySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConnectionConfig(instance.getConnectionConfig()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositorySpecBuilder(io.fabric8.openshift.api.model.HelmChartRepositorySpec instance) {
    this(instance,false);
  }
  public HelmChartRepositorySpecBuilder(io.fabric8.openshift.api.model.HelmChartRepositorySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConnectionConfig(instance.getConnectionConfig()); 
    this.withDescription(instance.getDescription()); 
    this.withDisabled(instance.getDisabled()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HelmChartRepositorySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HelmChartRepositorySpec build() {
    HelmChartRepositorySpec buildable = new HelmChartRepositorySpec(fluent.getConnectionConfig(),fluent.getDescription(),fluent.getDisabled(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}