package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IdentityFluentImpl<A extends IdentityFluent<A>> extends BaseFluent<A> implements IdentityFluent<A>{
  public IdentityFluentImpl() {
  }
  public IdentityFluentImpl(io.fabric8.openshift.api.model.Identity instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withExtra(instance.getExtra()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withProviderName(instance.getProviderName()); 
    this.withProviderUserName(instance.getProviderUserName()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private Map<java.lang.String,java.lang.String> extra;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private java.lang.String providerName;
  private java.lang.String providerUserName;
  private ObjectReferenceBuilder user;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToExtra(java.lang.String key,java.lang.String value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  public A addToExtra(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.extra == null && map != null) { this.extra = new java.util.LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  public A removeFromExtra(java.lang.String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  public A removeFromExtra(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getExtra() {
    return this.extra;
  }
  public <K,V>A withExtra(java.util.Map<java.lang.String,java.lang.String> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new java.util.LinkedHashMap(extra);} return (A) this;
  }
  public java.lang.Boolean hasExtra() {
    return this.extra != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public IdentityFluent.MetadataNested<A> withNewMetadata() {
    return new IdentityFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.IdentityFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new IdentityFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.IdentityFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.IdentityFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.IdentityFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.String getProviderName() {
    return this.providerName;
  }
  public A withProviderName(java.lang.String providerName) {
    this.providerName=providerName; return (A) this;
  }
  public java.lang.Boolean hasProviderName() {
    return this.providerName != null;
  }
  public java.lang.String getProviderUserName() {
    return this.providerUserName;
  }
  public A withProviderUserName(java.lang.String providerUserName) {
    this.providerUserName=providerUserName; return (A) this;
  }
  public java.lang.Boolean hasProviderUserName() {
    return this.providerUserName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getUser() {
    return this.user!=null ?this.user.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(io.fabric8.kubernetes.api.model.ObjectReference user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new ObjectReferenceBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
  }
  public java.lang.Boolean hasUser() {
    return this.user != null;
  }
  public IdentityFluent.UserNested<A> withNewUser() {
    return new IdentityFluentImpl.UserNestedImpl();
  }
  public io.fabric8.openshift.api.model.IdentityFluent.UserNested<A> withNewUserLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.IdentityFluentImpl.UserNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.IdentityFluent.UserNested<A> editUser() {
    return withNewUserLike(getUser());
  }
  public io.fabric8.openshift.api.model.IdentityFluent.UserNested<A> editOrNewUser() {
    return withNewUserLike(getUser() != null ? getUser(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.IdentityFluent.UserNested<A> editOrNewUserLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewUserLike(getUser() != null ? getUser(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IdentityFluentImpl that = (IdentityFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (providerName != null ? !providerName.equals(that.providerName) :that.providerName != null) return false;
    if (providerUserName != null ? !providerUserName.equals(that.providerUserName) :that.providerUserName != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  extra,  kind,  metadata,  providerName,  providerUserName,  user,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (providerName != null) { sb.append("providerName:"); sb.append(providerName + ","); }
    if (providerUserName != null) { sb.append("providerUserName:"); sb.append(providerUserName + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<IdentityFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.IdentityFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) IdentityFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class UserNestedImpl<N> extends ObjectReferenceFluentImpl<IdentityFluent.UserNested<N>> implements io.fabric8.openshift.api.model.IdentityFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    UserNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) IdentityFluentImpl.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}