package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IdentityProviderBuilder extends IdentityProviderFluentImpl<IdentityProviderBuilder> implements VisitableBuilder<IdentityProvider,io.fabric8.openshift.api.model.IdentityProviderBuilder>{
  public IdentityProviderBuilder() {
    this(false);
  }
  public IdentityProviderBuilder(Boolean validationEnabled) {
    this(new IdentityProvider(), validationEnabled);
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IdentityProvider(), validationEnabled);
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.IdentityProvider instance) {
    this(fluent, instance, false);
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.IdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withGithub(instance.getGithub()); 
    fluent.withGitlab(instance.getGitlab()); 
    fluent.withGoogle(instance.getGoogle()); 
    fluent.withHtpasswd(instance.getHtpasswd()); 
    fluent.withKeystone(instance.getKeystone()); 
    fluent.withLdap(instance.getLdap()); 
    fluent.withMappingMethod(instance.getMappingMethod()); 
    fluent.withName(instance.getName()); 
    fluent.withOpenID(instance.getOpenID()); 
    fluent.withRequestHeader(instance.getRequestHeader()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProvider instance) {
    this(instance,false);
  }
  public IdentityProviderBuilder(io.fabric8.openshift.api.model.IdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withGithub(instance.getGithub()); 
    this.withGitlab(instance.getGitlab()); 
    this.withGoogle(instance.getGoogle()); 
    this.withHtpasswd(instance.getHtpasswd()); 
    this.withKeystone(instance.getKeystone()); 
    this.withLdap(instance.getLdap()); 
    this.withMappingMethod(instance.getMappingMethod()); 
    this.withName(instance.getName()); 
    this.withOpenID(instance.getOpenID()); 
    this.withRequestHeader(instance.getRequestHeader()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IdentityProvider build() {
    IdentityProvider buildable = new IdentityProvider(fluent.getBasicAuth(),fluent.getGithub(),fluent.getGitlab(),fluent.getGoogle(),fluent.getHtpasswd(),fluent.getKeystone(),fluent.getLdap(),fluent.getMappingMethod(),fluent.getName(),fluent.getOpenID(),fluent.getRequestHeader(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}