package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeCauseBuilder extends ImageChangeCauseFluentImpl<ImageChangeCauseBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageChangeCause,ImageChangeCauseBuilder>{
  public ImageChangeCauseBuilder() {
    this(false);
  }
  public ImageChangeCauseBuilder(Boolean validationEnabled) {
    this(new ImageChangeCause(), validationEnabled);
  }
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeCauseBuilder(io.fabric8.openshift.api.model.ImageChangeCauseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageChangeCause(), validationEnabled);
  }
  public ImageChangeCauseBuilder(io.fabric8.openshift.api.model.ImageChangeCauseFluent<?> fluent,io.fabric8.openshift.api.model.ImageChangeCause instance) {
    this(fluent, instance, false);
  }
  public ImageChangeCauseBuilder(io.fabric8.openshift.api.model.ImageChangeCauseFluent<?> fluent,io.fabric8.openshift.api.model.ImageChangeCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFromRef(instance.getFromRef()); 
    fluent.withImageID(instance.getImageID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeCauseBuilder(io.fabric8.openshift.api.model.ImageChangeCause instance) {
    this(instance,false);
  }
  public ImageChangeCauseBuilder(io.fabric8.openshift.api.model.ImageChangeCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFromRef(instance.getFromRef()); 
    this.withImageID(instance.getImageID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageChangeCauseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageChangeCause build() {
    ImageChangeCause buildable = new ImageChangeCause(fluent.getFromRef(),fluent.getImageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}