package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeTriggerBuilder extends ImageChangeTriggerFluentImpl<ImageChangeTriggerBuilder> implements VisitableBuilder<ImageChangeTrigger,io.fabric8.openshift.api.model.ImageChangeTriggerBuilder>{
  public ImageChangeTriggerBuilder() {
    this(false);
  }
  public ImageChangeTriggerBuilder(Boolean validationEnabled) {
    this(new ImageChangeTrigger(), validationEnabled);
  }
  public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeTriggerBuilder(io.fabric8.openshift.api.model.ImageChangeTriggerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageChangeTrigger(), validationEnabled);
  }
  public ImageChangeTriggerBuilder(io.fabric8.openshift.api.model.ImageChangeTriggerFluent<?> fluent,io.fabric8.openshift.api.model.ImageChangeTrigger instance) {
    this(fluent, instance, false);
  }
  public ImageChangeTriggerBuilder(io.fabric8.openshift.api.model.ImageChangeTriggerFluent<?> fluent,io.fabric8.openshift.api.model.ImageChangeTrigger instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeTriggerBuilder(io.fabric8.openshift.api.model.ImageChangeTrigger instance) {
    this(instance,false);
  }
  public ImageChangeTriggerBuilder(io.fabric8.openshift.api.model.ImageChangeTrigger instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    this.withPaused(instance.getPaused()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageChangeTriggerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageChangeTrigger build() {
    ImageChangeTrigger buildable = new ImageChangeTrigger(fluent.getFrom(),fluent.getLastTriggeredImageID(),fluent.getPaused());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}