package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageImportSpecBuilder extends ImageImportSpecFluentImpl<ImageImportSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageImportSpec,io.fabric8.openshift.api.model.ImageImportSpecBuilder>{
  public ImageImportSpecBuilder() {
    this(false);
  }
  public ImageImportSpecBuilder(Boolean validationEnabled) {
    this(new ImageImportSpec(), validationEnabled);
  }
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageImportSpecBuilder(io.fabric8.openshift.api.model.ImageImportSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageImportSpec(), validationEnabled);
  }
  public ImageImportSpecBuilder(io.fabric8.openshift.api.model.ImageImportSpecFluent<?> fluent,io.fabric8.openshift.api.model.ImageImportSpec instance) {
    this(fluent, instance, false);
  }
  public ImageImportSpecBuilder(io.fabric8.openshift.api.model.ImageImportSpecFluent<?> fluent,io.fabric8.openshift.api.model.ImageImportSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withImportPolicy(instance.getImportPolicy()); 
    fluent.withIncludeManifest(instance.getIncludeManifest()); 
    fluent.withReferencePolicy(instance.getReferencePolicy()); 
    fluent.withTo(instance.getTo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageImportSpecBuilder(io.fabric8.openshift.api.model.ImageImportSpec instance) {
    this(instance,false);
  }
  public ImageImportSpecBuilder(io.fabric8.openshift.api.model.ImageImportSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withImportPolicy(instance.getImportPolicy()); 
    this.withIncludeManifest(instance.getIncludeManifest()); 
    this.withReferencePolicy(instance.getReferencePolicy()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageImportSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageImportSpec build() {
    ImageImportSpec buildable = new ImageImportSpec(fluent.getFrom(),fluent.getImportPolicy(),fluent.getIncludeManifest(),fluent.getReferencePolicy(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}