package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageLabelBuilder extends ImageLabelFluentImpl<ImageLabelBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageLabel,ImageLabelBuilder>{
  public ImageLabelBuilder() {
    this(false);
  }
  public ImageLabelBuilder(Boolean validationEnabled) {
    this(new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(ImageLabelFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,io.fabric8.openshift.api.model.ImageLabel instance) {
    this(fluent, instance, false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,io.fabric8.openshift.api.model.ImageLabel instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabel instance) {
    this(instance,false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabel instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageLabel build() {
    ImageLabel buildable = new ImageLabel(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}