package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageLayerBuilder extends ImageLayerFluentImpl<ImageLayerBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageLayer,ImageLayerBuilder>{
  public ImageLayerBuilder() {
    this(false);
  }
  public ImageLayerBuilder(Boolean validationEnabled) {
    this(new ImageLayer(), validationEnabled);
  }
  public ImageLayerBuilder(ImageLayerFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageLayer(), validationEnabled);
  }
  public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,io.fabric8.openshift.api.model.ImageLayer instance) {
    this(fluent, instance, false);
  }
  public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,io.fabric8.openshift.api.model.ImageLayer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMediaType(instance.getMediaType()); 
    fluent.withName(instance.getName()); 
    fluent.withSize(instance.getSize()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayer instance) {
    this(instance,false);
  }
  public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMediaType(instance.getMediaType()); 
    this.withName(instance.getName()); 
    this.withSize(instance.getSize()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageLayer build() {
    ImageLayer buildable = new ImageLayer(fluent.getMediaType(),fluent.getName(),fluent.getSize());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}